/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.api.VWScenarioRoleAssignment;
import filenet.sim.api.VWScenarioScheduleType;
import filenet.sim.api.VWScenarioShiftType;
import filenet.sim.api.VWScenarioTimeDuration;
import filenet.sim.api.VWScenarioTimeType;
import filenet.sim.api.VWScenarioTimeUnitType;
import filenet.sim.api.VWScenarioValidationError;
import filenet.sim.api.VWScenarioXMLHandler;
import filenet.vw.api.VWException;
import filenet.vw.base.VWString;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public final class VWScenarioShiftDefinition
implements Serializable,
Cloneable {
    private VWScenarioDefinition m_scenarioDef = null;
    private String m_name = null;
    private int m_shiftType = 1;
    private int m_scheduleType = 1;
    private VWScenarioTimeDuration m_duration = null;
    private long m_startTime = 0L;
    private int m_activeDays = 31;
    private int m_startInterval = 0;
    private int m_everyInterval = 1;
    private Integer m_occurrencesInterval = null;
    private Map m_roles = Collections.synchronizedMap(new HashMap());

    protected VWScenarioShiftDefinition(String name, VWScenarioDefinition scenarioDef) throws VWException {
        this.m_scenarioDef = scenarioDef;
        this.m_duration = new VWScenarioTimeDuration("8", 3);
        this.setName(name);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) throws VWException {
        if (name == null) {
            throw new VWException("sim.api.VWScenarioShiftDefinition.NullShiftNameParameter", "The name parameter can not be null.");
        }
        if (name.equals(this.m_name)) {
            return;
        }
        if (this.m_scenarioDef.hasShift(name)) {
            throw new VWException("sim.api.VWScenarioShiftDefinition.ShiftAlreadyExists", "A shift with the name {0} has already been created.", name);
        }
        this.m_scenarioDef.updateShift(this.m_name, name);
        this.m_name = name;
    }

    public VWScenarioRoleAssignment createRoleAssignment(String roleName) throws VWException {
        if (roleName == null) {
            throw new VWException("sim.api.VWScenarioShiftDefinition.NullRoleNameParameter", "The role name parameter can not be null.");
        }
        if (this.hasRole(roleName)) {
            throw new VWException("sim.api.VWScenarioShiftDefinition.RoleAssignmentAlreadyExists", "A role with the name {0} has already been assigned to this shift.", roleName);
        }
        if (!this.getScenario().hasRole(roleName)) {
            throw new VWException("sim.api.VWScenarioShiftDefinition.RoleNotFound", "No role found with name equal to {0} in scenario definition.", roleName);
        }
        VWScenarioRoleAssignment roleAssignment = new VWScenarioRoleAssignment(roleName, this);
        this.m_roles.put(roleName, roleAssignment);
        return roleAssignment;
    }

    public VWScenarioRoleAssignment[] getRoleAssignments() {
        if (this.m_roles.size() == 0) {
            return null;
        }
        return this.m_roles.values().toArray(new VWScenarioRoleAssignment[0]);
    }

    public VWScenarioRoleAssignment getRoleAssignment(String roleName) throws VWException {
        if (roleName == null) {
            throw new VWException("sim.api.VWScenarioShiftDefinition.NullRoleNameParameter", "The roleName parameter can not be null.");
        }
        if (!this.m_roles.containsKey(roleName)) {
            throw new VWException("sim.api.VWScenarioShiftDefinition.RoleAssignmentNotFound", "Role {0} has not been assigned to this shift.", roleName);
        }
        return (VWScenarioRoleAssignment)this.m_roles.get(roleName);
    }

    public void deleteRoleAssignment(String roleName) throws VWException {
        if (roleName == null) {
            throw new VWException("sim.api.VWScenarioShiftDefinition.NullRoleNameParameter", "The roleName parameter can not be null.");
        }
        if (!this.m_roles.containsKey(roleName)) {
            throw new VWException("sim.api.VWScenarioShiftDefinition.RoleAssignmentNotFound", "Role {0} has not been assigned to this shift.", roleName);
        }
        this.getRoleAssignment(roleName).releaseReferences();
        this.m_roles.remove(roleName);
    }

    protected void setRoleAssignments(Map roleAssignments) throws VWException {
        this.m_roles = roleAssignments;
        if (this.m_roles != null) {
            Iterator i = this.m_roles.values().iterator();
            while (i.hasNext()) {
                ((VWScenarioRoleAssignment)i.next()).setShift(this);
            }
        }
    }

    protected void updateRole(String oldName, String newName) throws VWException {
        VWScenarioRoleAssignment role = (VWScenarioRoleAssignment)this.m_roles.remove(oldName);
        if (role != null) {
            this.m_roles.put(newName, role);
        }
    }

    protected boolean hasRole(String roleName) throws VWException {
        return this.m_roles.containsKey(roleName);
    }

    public int getShiftType() {
        return this.m_shiftType;
    }

    public void setShiftType(int type) throws VWException {
        if (!VWScenarioShiftType.isValid(type)) {
            throw new VWException("sim.api.VWScenarioShiftDefinition.InvalidShiftType", "The type {0} is not a valid shift type.", new Integer(type));
        }
        this.m_shiftType = type;
    }

    public int getScheduleType() {
        return this.m_scheduleType;
    }

    public void setScheduleType(int type) throws VWException {
        if (!VWScenarioScheduleType.isValid(type)) {
            throw new VWException("sim.api.VWScenarioShiftDefinition.InvalidScheduleType", "The type {0} is not a valid schedule type.", new Integer(type));
        }
        this.m_scheduleType = type;
    }

    public long getStartTime() {
        return this.m_startTime;
    }

    public void setStartTime(long startTime) throws VWException {
        if (this.m_scheduleType != 1 && (startTime < 0L || startTime > 86400L)) {
            throw new VWException("sim.api.VWScenarioDefinition.InvalidTimeSecondsValue", "The time value {0} is invalid.", new Long(startTime));
        }
        this.m_startTime = startTime;
    }

    public VWScenarioTimeDuration getDuration() {
        return this.m_duration;
    }

    public void setDuration(VWScenarioTimeDuration duration) throws VWException {
        if (duration == null) {
            throw new VWException("sim.api.VWScenarioShiftDefinition.NullDurationParameter", "The duration parameter can not be null.");
        }
        this.m_duration = duration;
    }

    public int getActiveDays() {
        return this.m_activeDays;
    }

    public void setActiveDays(int days) {
        this.m_activeDays = days;
    }

    public int getStartInterval() {
        return this.m_startInterval;
    }

    public void setStartInterval(int startInterval) throws VWException {
        if (startInterval < 0) {
            throw new VWException("sim.api.VWScenarioShiftDefinition.InvalidStartInterval", "The value {0} is not a valid shift start interval. The interval must be greater than or equal to zero.");
        }
        this.m_startInterval = startInterval;
    }

    public int getEveryInterval() {
        return this.m_everyInterval;
    }

    public void setEveryInterval(int everyInterval) {
        this.m_everyInterval = everyInterval;
    }

    public Integer getOccurrencesInterval() {
        return this.m_occurrencesInterval;
    }

    public void setOccurrencesInterval(Integer occurrencesInterval) {
        this.m_occurrencesInterval = occurrencesInterval;
    }

    public void toXML(StringBuffer buffer) throws VWException {
        this.toXML(buffer, "");
    }

    protected void toXML(StringBuffer buffer, String baseIndent) throws VWException {
        String LEVEL_1_INDENT = baseIndent + "\t";
        String LEVEL_2_INDENT = LEVEL_1_INDENT + "\t";
        buffer.append(baseIndent + "<Shift ");
        buffer.append("Name=\"" + VWScenarioXMLHandler.toXMLString(this.getName()) + "\" ");
        buffer.append("Type=\"" + VWScenarioXMLHandler.toXMLString(VWScenarioShiftType.typeToString(this.getShiftType())) + "\" ");
        VWScenarioTimeDuration duration = this.getDuration();
        buffer.append("Duration=\"" + duration.getDuration() + "\" ");
        buffer.append("Units=\"" + VWScenarioTimeUnitType.typeToString(duration.getUnits()) + "\">\n");
        if (this.getScheduleType() == 1) {
            buffer.append(LEVEL_1_INDENT + "<Date Value=\"" + VWScenarioXMLHandler.convertDateToString(new Date(this.getStartTime())) + "\"/>\n");
        } else if (this.getScheduleType() == 2) {
            buffer.append(LEVEL_1_INDENT + "<Daily ");
            buffer.append("Time=\"" + VWScenarioXMLHandler.convertTimeValue((int)this.getStartTime()) + "\" ");
            buffer.append("Start=\"" + this.getStartInterval() + "\" ");
            buffer.append("Every=\"" + this.getEveryInterval() + "\" ");
            if (this.getOccurrencesInterval() != null) {
                buffer.append("Occurrences=\"" + this.getOccurrencesInterval() + "\" ");
            }
            buffer.append("/>\n");
        } else if (this.getScheduleType() == 3) {
            buffer.append(LEVEL_1_INDENT + "<Weekly ");
            buffer.append("Time=\"" + VWScenarioXMLHandler.convertTimeValue((int)this.getStartTime()) + "\" ");
            buffer.append("Start=\"" + this.getStartInterval() + "\" ");
            buffer.append("Every=\"" + this.getEveryInterval() + "\" ");
            if (this.getOccurrencesInterval() != null) {
                buffer.append("Occurrences=\"" + this.getOccurrencesInterval() + "\" ");
            }
            buffer.append(">\n");
            if ((1 & this.m_activeDays) == 1) {
                buffer.append(LEVEL_2_INDENT + "<Days Name=\"MON\"/>\n");
            }
            if ((2 & this.m_activeDays) == 2) {
                buffer.append(LEVEL_2_INDENT + "<Days Name=\"TUE\"/>\n");
            }
            if ((4 & this.m_activeDays) == 4) {
                buffer.append(LEVEL_2_INDENT + "<Days Name=\"WED\"/>\n");
            }
            if ((8 & this.m_activeDays) == 8) {
                buffer.append(LEVEL_2_INDENT + "<Days Name=\"THU\"/>\n");
            }
            if ((0x10 & this.m_activeDays) == 16) {
                buffer.append(LEVEL_2_INDENT + "<Days Name=\"FRI\"/>\n");
            }
            if ((0x20 & this.m_activeDays) == 32) {
                buffer.append(LEVEL_2_INDENT + "<Days Name=\"SAT\"/>\n");
            }
            if ((0x40 & this.m_activeDays) == 64) {
                buffer.append(LEVEL_2_INDENT + "<Days Name=\"SUN\"/>\n");
            }
            buffer.append(LEVEL_1_INDENT + "</Weekly>\n");
        }
        buffer.append(baseIndent + "</Shift>\n");
    }

    public void validate(Vector EDefVector) throws VWException {
        VWScenarioTimeType.validate(this.getDuration(), null, 5, this.getName(), null, null, EDefVector);
        try {
            double duration = Double.parseDouble(this.getDuration().getDuration());
            if (duration <= 0.0) {
                VWString theMessage = new VWString("sim.api.VWScenarioShiftDefinition", "Shift duration must be greater than zero.");
                VWScenarioValidationError theError = new VWScenarioValidationError(5, 1, this.getName(), null, theMessage.toString());
                EDefVector.addElement(theError);
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        Iterator i = this.m_roles.values().iterator();
        while (i.hasNext()) {
            ((VWScenarioRoleAssignment)i.next()).validate(EDefVector);
        }
    }

    public String toString() {
        return this.getName();
    }

    protected Object clone(String shiftName) {
        VWScenarioShiftDefinition clone = null;
        try {
            clone = (VWScenarioShiftDefinition)super.clone();
            clone.m_duration = (VWScenarioTimeDuration)VWScenarioTimeType.clone(this.m_duration);
            clone.m_roles = Collections.synchronizedMap(new HashMap());
            clone.m_name = shiftName;
            for (String key : this.m_roles.keySet()) {
                VWScenarioRoleAssignment value = (VWScenarioRoleAssignment)((VWScenarioRoleAssignment)this.m_roles.get(key)).clone();
                value.setShift(clone);
                clone.m_roles.put(key, value);
            }
        }
        catch (VWException e) {
            return null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    protected VWScenarioDefinition getScenario() {
        return this.m_scenarioDef;
    }

    protected void releaseReferences() throws VWException {
        Iterator i = this.m_roles.values().iterator();
        while (i.hasNext()) {
            ((VWScenarioRoleAssignment)i.next()).releaseReferences();
        }
    }
}

